'(
#########################################################################
### Serial-HV-Fuse-Programmer V0.5 with Tiny2313
### Stand-Alone-Version mit automatischer Erkennung des Target-Chips
### (CC) by-nc-sa JR2013 (basbaer@fakedomain.de)
### 22.04.2013
#########################################################################

Die gleiche Schaltung wie die serielle Version mit einer zustzlichen LED

Funktionsweise:
Schaltung unter Spannung setzen.
Zu flashenden Chip einsetzen.
Taster drcken oder Leertaste
Signature wird ausgelesen
Vergleich mit gespeicherten Daten
Wenn der Chip Gespeichert ist, werden die Fuses geflasht und der Chip gelscht.
Dann werden die Fuses verglichen ob es funktioniert hat.
Wenn alles erfolgreich war blinkt die Work-LED
Ist ein Fehler aufgetreten, also wenn der Chip nicht gefunden wurde oder das
Flashen war nicht erfolgreich, blinkt die Error-LED.
Mit dem erneuten Drcken des Tasters oder Leertaste beginnt das Programm von
vorn.
Die Serielle Schnittstelle dient als Tasterersatz mit Leertaste und zur
LOG-Ausgabe

Im Moment werden die tinys 24, 44, 84, 25, 45, 85 und der tiny13 untersttzt.
Weitere knnen im EEPROM einfach eingetragen werden, maximal 15 Stck.
128 Bytes EEPROM - 1 Byte = 127Byte / 8Byte pro Eintrag = 15 Eintrge im EEPROM

Viel Spass
')

$regfile = "attiny2313.dat"
$crystal = 8000000                                          ' used internal crystal
$hwstack = 32                                               ' default use 32
$swstack = 10                                               ' default use 10
$framesize = 40                                             ' default use 40
$baud = 9600
Baud = 9600

Vcc_p Alias Portb.0
Rst Alias Portb.1
Sdi Alias Portb.2
Sii Alias Portb.3
Sdo Alias Pinb.4
Sdo_o Alias Portb.4
Sdc Alias Portb.5
Config Portb = Output

Taster Alias Pind.6
Config Taster = Input
Set Portd.6

Work_led Alias Portd.4
Config Work_led = Output
Error_led Alias Portd.5
Config Error_led = Output

Const Aus = 0
Const Ein = 1
Const Ledaus = 1
Const Ledein = 0

Dim Sdo_data As Byte
Dim Sdi_data As Byte
Dim Sii_data As Byte

Dim Signature As Dword
Dim Signatur_b1 As Byte At Signature + 1 Overlay
Dim Signatur_b2 As Byte At Signature + 2 Overlay
Dim Signatur_b3 As Byte At Signature + 3 Overlay

Dim Search_sig As Dword

Dim Allfuses As Dword
Dim Hfuse As Byte At Allfuses + 1 Overlay
Dim Lfuse As Byte At Allfuses + 2 Overlay
Dim Efuse As Byte At Allfuses + 3 Overlay

Dim Search_fuse As Dword
Dim Chipnr As Byte At Search_fuse Overlay

Dim D_count As Byte
Dim Count As Byte
Dim Temp As Byte
Dim Chip As Byte

'#########################################################################
Do
Init:

    Portb = 0                                               ' Port AUS
    Work_led = Ledaus                                       ' LEDs aus
    Error_led = Ledaus

    '#########################################################################
    Print "{013}{010}Wait"
    Do
        Debounce Taster , 0 , Autoerase                     ' wenn Taster gedrckt wird, dann los
        If Ischarwaiting() = 1 Then                         ' oder wenn Space-Taste gedrckt wird
            If Waitkey() = 32 Then Exit Do
        End If
    Loop

    '### hier gehts los ###
    Autoerase:
    Print "Start"
    Gosub Enable_prog_mode                                  ' Programmiermodus ein
    Gosub Read_signature                                    ' und Signature lesen

    Count = 0                                               ' Zhler auf Null
    Do
        Temp = Count * 8                                    ' Dann Speicherposition berechnen
        Incr Temp                                           ' und eins dabei
        Readeeprom Search_sig , Temp                        ' Lese Signature aus EEPROM
        Temp = Temp + 4                                     ' vier weiter im EEPROM
        Readeeprom Search_fuse , Temp                       ' lese Fuses dazu aus
        If Search_sig = Signature Then Exit Do              ' wenn es die richtige Sig, dann beenden
        Incr Count                                          ' ansonsten hochzhlen
    Loop Until Search_sig = &HFFFFFFFF                      ' solange bis nix mehr kommt

    If Search_sig <> &HFFFFFFFF Then                        ' wenn was gefunden
        Print "Found tiny" ; Hex(chipnr)                    ' Info

        Gosub Read_fuses                                    ' Fuses wieder einlesen
        Print "Programmed Fuses"
        Print "H:" ; Hex(hfuse) ; " L:" ; Hex(lfuse) ; " E:" ; Hex(efuse)

        Allfuses = Search_fuse                              ' Fuse-Werte bergeben
        Print "Flash"                                       ' Info
        Chipnr = 0
        Gosub Prog_fuses                                    ' und brennen
        Print "Erase"                                       ' Info
        Gosub Chip_erase                                    'Chip lschen
        Allfuses = &HFFFFFF00                               ' Fuses lschen
        Gosub Read_fuses                                    ' Fuses wieder einlesen
        Gosub Disable_prog_mode                             ' OK, Programmiermodus aus
        Print "H:" ; Hex(hfuse) ; " L:" ; Hex(lfuse) ; " E:" ; Hex(efuse)
        If Allfuses = Search_fuse Then                      ' wenn ok
            Print "OK"
            Work_led = Ledein                               ' Workled ein
            Temp = 0
        Else
            Print "Error-Flash"
            Error_led = Ledein                              ' ansonsten Errorled ein
            Temp = 1
        End If
    Else
        Print "Not found"
        Gosub Disable_prog_mode                             ' OK, Programmiermodus aus
        Error_led = Ledein                                  ' Errorled ein
        Temp = 1
    End If

    Do
        Waitms 500                                          ' Warte , damit man den Taster loslassen kann
        If Temp = 1 Then Toggle Error_led Else Toggle Work_led
        Debounce Taster , 0 , Init                          ' warte auf Taster
        If Ischarwaiting() = 1 Then                         ' oder Space via serielle
            If Waitkey() = 32 Then Exit Do
        End If

    Loop
Loop
End


'#########################################################################
'### Unterroutinen
Prog_fuses:
    Gosub Write_l_fuse
    While Sdo = 0
    Wend
    Gosub Write_h_fuse
    While Sdo = 0
    Wend
    If Efuse > 0 Then
        Gosub Write_e_fuse
        While Sdo = 0
        Wend
    End If
Return


Read_fuses:
    Gosub Read_l_fuse
    Gosub Read_h_fuse
    Gosub Read_e_fuse
    While Sdo = 0
    Wend
Return


Chip_erase:
    Sdi_data = &H80 : Sii_data = &H4C
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H64
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H6C
    Gosub Data_out
    While Sdo = 0
    Wend
Return


Read_signature:
    Sdi_data = &H08 : Sii_data = &H4C
    Gosub Data_out

    Sdi_data = &H00 : Sii_data = &H0C
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H68
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H6C
    Gosub Data_out
    Signatur_b1 = Sdo_data

    Sdi_data = &H01 : Sii_data = &H0C
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H68
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H6C
    Gosub Data_out
    Signatur_b2 = Sdo_data

    Sdi_data = &H02 : Sii_data = &H0C
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H68
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H6C
    Gosub Data_out
    Signatur_b3 = Sdo_data
Return


Read_l_fuse:
    Sdi_data = &H04 : Sii_data = &H4C
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H68
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H6C
    Gosub Data_out
    Lfuse = Sdo_data
Return


Read_h_fuse:
    Sdi_data = &H04 : Sii_data = &H4C
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H7A
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H7E
    Gosub Data_out
    Hfuse = Sdo_data
Return


Read_e_fuse:
    Sdi_data = &H04 : Sii_data = &H4C
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H6A
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H6E
    Gosub Data_out
    Efuse = Sdo_data                                        ' And 1
Return


Write_h_fuse:
    Sdi_data = &H40 : Sii_data = &H4C
    Gosub Data_out
    Sdi_data = Hfuse : Sii_data = &H2C
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H74
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H7C
    Gosub Data_out
Return


Write_l_fuse:
    Sdi_data = &H40 : Sii_data = &H4C
    Gosub Data_out
    Sdi_data = Lfuse : Sii_data = &H2C
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H64
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H6C
    Gosub Data_out
Return


Write_e_fuse:
    Sdi_data = &H40 : Sii_data = &H4C
    Gosub Data_out
    Sdi_data = Efuse : Sii_data = &H2C
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H66
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H6E
    Gosub Data_out
Return


Enable_prog_mode:
    Work_led = Ledein
    Config Sdo = Output
    Reset Sdo_o
    Reset Sdi
    Reset Sii

    Vcc_p = Ein
    Waitus 40
    Rst = Ein
    Waitus 20
    Config Sdo = Input
    Waitus 400
Return


Disable_prog_mode:
    Rst = Aus
    Vcc_p = Aus
    Config Sdo = Output
    Work_led = Ledaus
Return



Data_out:
    Sdo_data = 0
    ' Wait until SDO goes high
    While Sdo = 0
    Wend

    Reset Sdi
    Reset Sii
    Set Sdc
    Reset Sdc

    For D_count = 7 To 0 Step -1
        Sdi = Sdi_data.d_count
        Sii = Sii_data.d_count
        Shift Sdo_data , Left , 1
        Sdo_data = Sdo_data Or Sdo
        Set Sdc
        Reset Sdc
    Next D_count

    Reset Sdi
    Reset Sii
    Set Sdc
    Reset Sdc
    Set Sdc
    Reset Sdc
Return


'#########################################################################
'### Signaturen, Kennungen und Default-Fuses von einigen Tinys
'### Aufbau im EEPROM:
'### 1.Byte bleibt frei
'### dann jeweils 4 Byte (DWord) Signature mit fhrendem Nullbyte
'### dann vier Bytes mit folgendem Aufbau
'### 1.Byte Chipnummer
'### 2.Byte HFuse
'### 3.Byte Lfuse
'### 4.Byte EFuse  Wenn EFuse 00 ist, wird sie nicht geflasht
$eeprom
Data 0
Data &H00 , &H1E , &H91 , &H08 , &H25 , &HDF , &H62 , &HFF  ' Tiny25
Data &H00 , &H1E , &H92 , &H06 , &H45 , &HDF , &H62 , &HFF  ' Tiny45
Data &H00 , &H1E , &H93 , &H0B , &H85 , &HDF , &H62 , &HFF  ' Tiny85
Data &H00 , &H1E , &H91 , &H0B , &H24 , &HDF , &H62 , &HFF  ' Tiny24
Data &H00 , &H1E , &H92 , &H07 , &H44 , &HDF , &H6A , &HFF  ' Tiny44
Data &H00 , &H1E , &H93 , &H0C , &H84 , &HDF , &H6A , &HFF  ' Tiny84
Data &H00 , &H1E , &H90 , &H07 , &H13 , &HFF , &H6A , &H00  ' Tiny13

$data