'(
#########################################################################
### Serial-HV-Fuse-Programmer V0.4 with Tiny2313
### (CC) by-nc-sa JR2013 (basbaer@fakedomain.de)
### 18.04.2013
#########################################################################

Zuerst einmal. Es werden nur die H-Fuse und die L-Fuse gebrannt, fr die
E-Fuse war der Speicher des tiny zu klein. Vielleicht klappt es wenn man
optimiert, aber mir reichte das schon.

Bedienung
1.Mglichkeit ber den Taster. Dadurch werden, wenn nicht anders
eingestellt, die Defaultwerte der Fuses in den Prozessor gebrannt.

2.Mglichkeit ber die serielle Schnittstelle
Dazu stehen folgende Kommandos zur Verfgung. Jedes Kommando muss mit CR
besttigt werden. Grossschreibung beim Kommando ist ntig

R    = Lese Fuses aus Prozessor und zeige sie an
P    = Programmieren der eingestellten Fuses
L XX = L-Fuse setzen. Den Wert in Hex eingeben
H XX = H-Fuse setzen. Den Wert in Hex eingeben
       Werte ausserhalb 0-9, A-F knnen zu seltsamen Werten fhren, also
       aufpassen.
A    = eingestellte Fuses anzeigen
S    = Lese Prozessorsignature und zeige sie an

Der Programmer zeigt "Warte" an. Nach Eingabe des Kommandos besttigt der
Programmer dies. Dann entweder bei L oder H die Hex-Werte oder direkt mit
CR besttigen. Solange der Programmer arbeitet und Spannung am Sockel ansteht,
leuchtet die Programmierled.
')

$regfile = "attiny2313.dat"
$crystal = 8000000                                          ' used internal crystal
$hwstack = 32                                               ' default use 32
$swstack = 10                                               ' default use 10
$framesize = 40                                             ' default use 40
$baud = 9600
Baud = 9600

Vcc_p Alias Portb.0
Rst Alias Portb.1
Sdi Alias Portb.2
Sii Alias Portb.3
Sdo Alias Pinb.4
Sdo_o Alias Portb.4
Sdc Alias Portb.5
Config Portb = Output

Taster Alias Pind.6
Config Taster = Input
Set Portd.6

Work_led Alias Portd.4
Config Work_led = Output

'############## Defaultwerte fr die Fuses, ggf. ndern #####################
Const Def_hfuse = &HDF
Const Def_lfuse = &H6A
Const Def_efuse = &HFF
'############################################################################
Const Aus = 0
Const Ein = 1
Const Ledaus = 1
Const Ledein = 0

Dim Sdo_data As Byte
Dim Sdi_data As Byte
Dim Sii_data As Byte

Dim Lfuse As Byte
Dim Hfuse As Byte
Dim Efuse As Byte
Dim Temp_fuse As Byte

Dim D_count As Byte

Dim Count As Byte

Dim Rec_char As Byte

Dim Rec_string As String * 1
Dim Command_string As String * 8
Dim Progstate As Byte
Dim Kommando As Byte


'#########################################################################
Init:

    Portb = 0
    Lfuse = Def_lfuse
    Hfuse = Def_hfuse
    Efuse = Def_efuse
    Print "Serial-HV-Fuse-Programmer V0.4"
    Print "{013}{010}Warte"
    Work_led = Ledaus
    Kommando = 0
    Rec_string = ""
    Command_string = "RSPLHA"

'#########################################################################
Main:

'Debounce Taster , 0 , Prog_fuses , Sub
Debounce Taster , 0 , Read_signature , Sub

If Ischarwaiting() = 1 Then
    Rec_char = Waitkey()

    If Rec_char <> 32 Then
        If Kommando = 0 Then
            Rec_string = Chr(rec_char)
            If Instr(command_string , Rec_string) > 0 Then
                Temp_fuse = 0
                Kommando = Rec_char
                Print "Kommando: " ; Chr(rec_char)
            End If
        Else
            Select Case Rec_char
            Case 13
                Select Case Kommando
                Case 82                                     ' R = Lese Fuses
                    Gosub Read_fuses
                Case 83                                     ' S = Lese Signature
                    Gosub Read_signature
                Case 80                                     ' P = Programmieren
                    Gosub Prog_fuses
                Case 76                                     ' L = LFUSE
                    Lfuse = Temp_fuse
                    Gosub Print_fuses
                Case 72                                     ' H = HFUSE
                    Hfuse = Temp_fuse
                    Gosub Print_fuses
                Case 69                                     ' E = EFUSE
                    Efuse = Temp_fuse
                    Gosub Print_fuses
                Case 65                                     ' A = Fuses Anzeigen
                    Gosub Print_fuses
                End Select
                Kommando = 0
                Print "{013}{010}Warte"
            Case Else
                If Kommando = 76 Or Kommando = 72 Then
                    Shift Temp_fuse , Left , 4
                    Rec_string = Chr(rec_char)
                    Temp_fuse = Temp_fuse + Hexval(rec_string)
                Else
                    Kommando = Rec_char
                    Temp_fuse = 0
                End If
            End Select
        End If
    End If
End If
Goto Main
End


Print_fuses:
    Print "LFuse: " ; Hex(lfuse)
    Print "HFuse: " ; Hex(hfuse)
    Print "EFuse: " ; Hex(efuse)
Return


Prog_fuses:
    Print "{013}{010}Programmiere Fuses"

    Gosub Read_fuses
    Gosub Enable_prog_mode

    Print "{013}{010}Schreibe"
    Print "LFuse: " ; Hex(lfuse)
    Gosub Write_l_fuse
    While Sdo = 0
    Wend
    Print "HFuse: " ; Hex(hfuse)
    Gosub Write_h_fuse
    While Sdo = 0
    Wend
    Gosub Disable_prog_mode

    Gosub Read_fuses
Return


Read_fuses:
    Print "{013}{010}Prozessor-Fuses"
    Gosub Enable_prog_mode
    Gosub Read_l_fuse
    Print "LFuse: " ; Hex(sdo_data)
    Gosub Read_h_fuse
    Print "HFuse: " ; Hex(sdo_data)
    Gosub Read_e_fuse
    Print "EFuse: " ; Hex(sdo_data)
    While Sdo = 0
    Wend
    Gosub Disable_prog_mode
Return


'Chip_erase:
'    Print "{013}{010}Chip erase"
'    Gosub Enable_prog_mode
'    Sdi_data = &H80 : Sii_data = &H4C
'    Gosub Data_out
'    Sdi_data = &H00 : Sii_data = &H64
'    Gosub Data_out
'    Sdi_data = &H00 : Sii_data = &H6C
'    Gosub Data_out
'Return


Read_signature:
    Print "{013}{010}Signatur"
    Gosub Enable_prog_mode

    SDI_data = &H08 : SII_data = &H4C
    Gosub Data_out

    SDI_data = &H00 : SII_data = &H0C
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H68
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H6C
    Gosub Data_out
    Print "Gelesen: " ; Hex(SDO_data) ; " ";

    SDI_data = &H01 : SII_data = &H0C
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H68
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H6C
    Gosub Data_out
    Print Hex(SDO_data) ; " ";

    SDI_data = &H02 : SII_data = &H0C
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H68
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H6C
    Gosub Data_out
    Print Hex(SDO_data)
    Gosub Disable_prog_mode
Return


Read_l_fuse:
    Sdi_data = &H04 : Sii_data = &H4C
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H68
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H6C
    Gosub Data_out
Return


Read_h_fuse:
    SDI_data = &H04 : SII_data = &H4C
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H7A
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H7E
    Gosub Data_out
Return


Read_e_fuse:
    SDI_data = &H04 : SII_data = &H4C
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H6A
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H6E
    Gosub Data_out
    Efuse = SDO_data
Return


Write_h_fuse:
    SDI_data = &H40 : SII_data = &H4C
    Gosub Data_out
    SDI_data = Hfuse : SII_data = &H2C
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H74
    Gosub Data_out
    SDI_data = &H00 : SII_data = &H7C
    Gosub Data_out
Return


Write_l_fuse:
    SDI_data = &H40 : SII_data = &H4C
    Gosub Data_out
    SDI_data = Lfuse : SII_data = &H2C
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H64
    Gosub Data_out
    Sdi_data = &H00 : Sii_data = &H6C
    Gosub Data_out
Return


Enable_prog_mode:
    Work_led = Ledein
    Config Sdo = Output
    Reset Sdo_o
    Reset Sdi
    Reset Sii

    Vcc_p = Ein
    Waitus 40
    Rst = Ein
    Waitus 20
    Config Sdo = Input
    Waitus 400
Return


Disable_prog_mode:
    Rst = Aus
    Vcc_p = Aus
    Config Sdo = Output
    Work_led = Ledaus
Return



Data_out:
    SDO_data = 0
    ' Wait until SDO goes high
    While Sdo = 0
    Wend

    Reset Sdi
    Reset Sii
    Set Sdc
    Reset Sdc

    For D_count = 7 To 0 Step -1
        Sdi = SDI_data.d_count
        Sii = SII_data.d_count
        Shift Sdo_data , Left , 1
        SDO_data = SDO_data Or Sdo
        Set Sdc
        Reset Sdc
    Next D_count

    Reset Sdi
    Reset Sii
    Set Sdc
    Reset Sdc
    Set Sdc
    Reset Sdc
Return
$eeprom
Data "Serial-HV-Fuse-Programmer V0.3 (CC) by-nc-sa JR2013 (basbaer@fakedomain.de){013}{010}"
$data
